/*
 * Decompiled with CFR 0.152.
 */
package flash.objects;

import flash.objects.FFill;
import flash.objects.FGradient;
import flash.objects.FGradientRecord;
import flash.objects.FMatrix;
import flash.objects.FMorphGradientRecord;
import java.util.Vector;

public class FMorphGradient
extends FFill {
    private FMatrix myStartMatrix;
    private FMatrix myEndMatrix;
    private Vector myGradient;
    private float alpha;

    public FMorphGradient(int n, FMatrix fMatrix, FMatrix fMatrix2, Vector vector) {
        super(n);
        this.myStartMatrix = fMatrix;
        this.myEndMatrix = fMatrix2;
        this.myGradient = vector;
        int n2 = 0;
        this.alpha = 0.0f;
        for (int i = 0; i < this.myGradient.size(); ++i) {
            FMorphGradientRecord fMorphGradientRecord = (FMorphGradientRecord)this.myGradient.get(i);
            n2 += fMorphGradientRecord.getStartColor().getA();
        }
        this.alpha = (float)n2 / (float)this.myGradient.size();
    }

    @Override
    public FFill morph(float f) {
        Vector<FGradientRecord> vector = new Vector<FGradientRecord>();
        for (int i = 0; i < this.myGradient.size(); ++i) {
            FMorphGradientRecord fMorphGradientRecord = (FMorphGradientRecord)this.myGradient.get(i);
            int n = fMorphGradientRecord.getStartRatio();
            int n2 = fMorphGradientRecord.getEndRatio();
            int n3 = 0;
            if (n > n2) {
                n3 = n - n2;
                n3 = (int)((float)n - (float)n3 * f);
            } else {
                n3 = n2 - n;
                n3 = (int)((float)n + (float)n3 * f);
            }
            vector.add(new FGradientRecord(n3, fMorphGradientRecord.getStartColor().morphTo(fMorphGradientRecord.getEndColor(), f)));
        }
        return new FGradient(3, this.getStyle(), this.myStartMatrix.morphTo(this.myEndMatrix, f), vector);
    }

    public void setAlpha(float f) {
        this.alpha = f;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public FMatrix getStatMatrix() {
        return this.myStartMatrix;
    }

    public FMatrix getEndMatrix() {
        return this.myEndMatrix;
    }

    public Vector getGradient() {
        return this.myGradient;
    }
}

